

function createRentalContract( evt ) {
	let anch = evt.target;
	
	let artId = anch.getAttribute('articleid');
	let date = anch.getAttribute('selecteddate');
	
	gotoRoute( '/sales/rental/new/?aid=' + artId + '&d=' + date );
}



export async function showRentalArticleInfo( articleId, opts ) {
	opts = opts ? opts : {};
	
	
	let r = await postJson( '/service/sales/rental/rental.do', {
		a: 'articleInfo',
		articleId: articleId,
		rentalContractId: opts.rentalContractId
	});
	
	let json = await r.json();
	
	
	let tpl = `
		<div class="rental-article-info-popup">
			<div class="page-header">
				<div class="toolbox">
					<a href="javascript:void(0);" onclick="close_popup();" class="fa fa-times-circle"></a>
				</div>
				<h1>{{ art.shortDescription }}</h1>
			</div>
			
			<table class="">
				<tr>
					<td style="width: 150px;">{{_('Active')}}</td>
					<td>{{ art.active ? _('Yes') : _('No') }}</td>
				</tr>
				<tr>
					<td>Artikel</td>
					<td>{{ art.shortDescription }}</td>
				</tr>
				<tr>
					<td>{{_('Pricing method')}}</td>
					<td>{{ _('pricingmethod.'+art.pricingMethod) }}</td>
				</tr>
				<tr>
					<td>{{_('Price excl.')}}</td>
					<td>
						{{ format_price(art.priceExclVat, true) }}
					</td>
				</tr>
				<tr>
					<td>{{_('Price incl.')}}</td>
					<td>
						{{ format_price(art.priceInclVat, true) }}
					</td>
				</tr>
			</table>
			
			<br/>
			<div class="action-box">
				<span><a href="javascript:void(0);" [articleid]="art.articleId" [selecteddate]="selectedDate" [onclick]="funcs.createRentalContract">{{_('Create contract')}}</a></span>
			</div>
			
			<h2>{{_('Rental contracts')}}</h2>
			<table class="table table-rental-contracts">
				<thead>
					<tr>
						<th>{{_('Customer name')}}</th>
						<th>{{_('Period')}}</th>
					</tr>
				</thead>
				
				<tbody ez-for="lines" ez-item="l">
					<tr class="clickable {{l.rentalContractId == selectedRentalContractId ? 'selected' : '' }}" 
						onclick="gotoRoute('/sales/rental/edit/?id='+this.id);" 
						[id]="l.rentalContractId">
						<td>{{l.customerName}}</td>
						<td>
							{{format_date(l.startTime, {dmy:true})}}
							
							<span ez-if="l.endTime ? true : false">
								t/m {{format_date(l.endTime, {dmy:true})}}
							</span>
						</td>
										
					</tr>
				</tbody>
				
				<tbody ez-if="lines.length == 0">
					<tr class="no-results-found">
						<td colspan="100%">
							{{_('No results found')}}
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	`;
	
	
	let div = document.createElement('div');
	
	let eztpl = new EzTemplate(div);
	eztpl.loadHtml( tpl );
	eztpl.setVar( 'art', json.article );
	eztpl.setVar( 'lines', json.rentalContractLines );
	eztpl.setVar( 'selectedDate', opts.date ? opts.date : '');
	eztpl.setVar( 'selectedRentalContractId', opts.rentalContractId ? opts.rentalContractId : null);
	eztpl.setVar('funcs', {
		createRentalContract: createRentalContract
	});
	eztpl.render();
	
	show_popup('Contract info', div);
}







